(function () {
//     const ICON_SVG = `data:image/svg+xml;utf8,${encodeURIComponent(`
// <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 500" width="500px"
//      height="500px">
//     <defs>
//         <linearGradient gradientUnits="userSpaceOnUse" x1="263.866" y1="-47.68" x2="263.866" y2="140.749"
//                         id="gradient-0" gradientTransform="matrix(1, 0, 0, 1, -125.279437, 200.283595)">
//             <stop offset="0" style="stop-color: rgb(62.745% 19.608% 96.078%)"/>
//             <stop offset="1" style="stop-color: rgb(41.006% 0% 74.852%)"/>
//         </linearGradient>
//         <linearGradient gradientUnits="userSpaceOnUse" x1="363.654" y1="-105.223" x2="363.654" y2="181.837"
//                         id="gradient-1" spreadMethod="pad"
//                         gradientTransform="matrix(1, 0, 0, 1, -113.420563, 211.707094)">
//             <stop offset="0" style="stop-color: rgb(80.784% 21.176% 70.98%)"/>
//             <stop offset="1" style="stop-color: rgb(55.936% 0% 48.44%)"/>
//         </linearGradient>
//         <linearGradient gradientUnits="userSpaceOnUse" x1="460.925" y1="-54.947" x2="460.925" y2="141.087"
//                         id="gradient-2" gradientTransform="matrix(1, 0, 0, 1, -100.436898, 207.22354)">
//             <stop offset="0" style="stop-color: rgb(94.118% 24.706% 43.922%)"/>
//             <stop offset="1" style="stop-color: rgb(64.78% 0% 24.178%)"/>
//         </linearGradient>
//         <linearGradient id="gradient-9">
//             <stop offset="0.334" style="stop-color: rgb(36, 0, 255);"/>
//         </linearGradient>
//     </defs>
//     <ellipse cx="250" cy="250" rx="250" ry="250" style="fill: rgb(255, 255, 255);"/>
//     <path d="M 265.045 110.547 C 270.454 114.68 273.41 119.66 275.17 126.17 C 275.462 129.54 275.811 366.426 275.825 367.39 C 275.739 374.185 273.991 379.513 270.17 385.169 C 264.229 390.909 258.112 393.444 249.795 393.544 C 241.634 393.378 236.982 391.34 231.357 385.482 C 225.405 378.88 224.726 370.396 224.782 361.898 C 224.777 360.902 224.649 136.872 224.64 135.934 C 224.734 127.55 226.708 119.46 232.482 113.17 C 241.62 105.157 254.504 104.427 265.045 110.547 Z"
//           style="stroke-width: 1; fill: url(&quot;#gradient-1&quot;); paint-order: fill;"/>
//     <path d="M 353.866 155.309 C 360.502 159.306 363.856 165.167 366.343 172.328 C 367.798 178.348 367.686 184.402 367.641 190.559 C 367.623 193.021 367.631 195.481 367.645 197.943 C 367.674 204.054 367.661 210.164 367.65 216.274 C 367.641 221.453 367.65 226.632 367.679 231.811 C 367.686 234.216 367.669 236.619 367.652 239.023 C 367.654 248.935 368.234 258.632 374.53 266.75 C 381.348 271.783 386.792 272.521 395.155 271.687 C 398.271 270.925 401.203 269.94 404.155 268.687 C 404.815 277.135 403.621 284.723 398.682 291.797 C 393.317 297.732 387.101 300.344 379.202 301.031 C 370.241 301.322 363.39 300.676 356.439 294.572 C 355.511 293.762 355.511 293.762 354.565 292.935 C 354.1 292.523 353.634 292.112 353.155 291.687 C 353.181 292.877 353.207 294.067 353.234 295.292 C 353.325 299.747 353.382 304.2 353.429 308.655 C 353.454 310.576 353.488 312.496 353.532 314.416 C 354 335.598 354 335.598 348.155 342.687 C 344.173 346.358 340.592 347.978 335.155 348.312 C 329.862 348.011 326.042 346.278 322.155 342.687 C 317.909 337.174 317.033 332.022 317.008 325.237 C 317.002 324.269 317.002 324.269 316.997 323.281 C 316.986 321.119 316.982 318.958 316.978 316.796 C 316.972 315.245 316.965 313.695 316.958 312.144 C 316.937 307.052 316.927 301.959 316.917 296.867 C 316.912 295.112 316.908 293.356 316.904 291.6 C 316.885 283.35 316.871 275.1 316.863 266.849 C 316.853 257.339 316.827 247.829 316.786 238.319 C 316.756 230.96 316.741 223.601 316.738 216.242 C 316.735 211.851 316.727 207.46 316.701 203.069 C 316.678 198.933 316.674 194.799 316.684 190.663 C 316.685 189.152 316.678 187.64 316.665 186.128 C 316.582 176.481 316.974 167.773 323.338 160.031 C 324.082 159.423 324.826 158.814 325.592 158.187 C 326.704 157.244 326.704 157.244 327.838 156.281 C 335.795 150.807 345.301 151.407 353.866 155.309 Z"
//           style="stroke-width: 1; fill: url(&quot;#gradient-2&quot;);"/>
//     <path d="M 172.312 155.745 C 179.096 160.076 182.157 165.053 184.312 172.745 C 184.874 177.792 184.86 182.819 184.829 187.89 C 184.835 189.396 184.842 190.902 184.851 192.408 C 184.869 196.47 184.862 200.531 184.849 204.593 C 184.839 208.857 184.848 213.122 184.855 217.386 C 184.862 224.543 184.852 231.7 184.833 238.856 C 184.812 247.117 184.819 255.377 184.841 263.638 C 184.859 270.748 184.861 277.858 184.851 284.968 C 184.845 289.207 184.844 293.446 184.857 297.685 C 184.869 301.669 184.86 305.653 184.837 309.638 C 184.832 311.095 184.834 312.553 184.842 314.011 C 184.93 329.938 184.93 329.938 178.829 336.289 C 174.294 340.291 170.499 341.103 164.659 341.027 C 159.715 340.434 156.448 337.912 152.999 334.37 C 149.674 329.197 149.056 324.438 148.993 318.363 C 148.983 317.65 148.973 316.937 148.963 316.203 C 148.932 313.866 148.915 311.528 148.898 309.191 C 148.879 307.563 148.859 305.935 148.839 304.306 C 148.788 300.036 148.748 295.765 148.711 291.493 C 148.671 287.129 148.62 282.766 148.57 278.402 C 148.473 269.85 148.389 261.298 148.312 252.745 C 147.907 253.233 147.502 253.721 147.084 254.223 C 146.549 254.859 146.014 255.495 145.463 256.15 C 144.934 256.782 144.405 257.414 143.86 258.065 C 141.989 260.096 140.257 261.131 137.687 262.12 C 136.952 262.417 136.217 262.713 135.46 263.019 C 126.781 265.954 117.675 265.64 109.312 261.745 C 106.342 259.672 103.819 257.352 101.312 254.745 C 100.198 253.601 100.198 253.601 99.062 252.433 C 95.526 247.003 93.522 241.077 92.312 234.745 C 93.038 234.67 93.764 234.595 94.512 234.518 C 97.821 234.168 101.129 233.801 104.437 233.433 C 105.579 233.315 106.721 233.197 107.898 233.076 C 115.178 232.25 120.537 231.391 125.999 226.183 C 133.894 215.979 132.557 200.412 132.654 188.324 C 132.912 177.182 135.213 166.881 143.312 158.745 C 152.348 151.869 161.984 150.618 172.312 155.745 Z"
//           style="stroke-width: 1; fill: url(&quot;#gradient-0&quot;);"/>
// </svg>
//   `)}`;
    const ICON_SVG = `data:image/svg+xml;utf8,${encodeURIComponent(`
<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="128" height="128" viewBox="0 0 128 128">
  <defs>
    <linearGradient id="grad1" x1="0%" y1="0%" x2="100%" y2="100%">
      <stop offset="0%" style="stop-color:#7B61FF;stop-opacity:1"/>
      <stop offset="100%" style="stop-color:#FF6B6B;stop-opacity:1"/>
    </linearGradient>
  </defs>
  
  <circle cx="64" cy="64" r="59" fill="none" stroke="url(#grad1)" stroke-width="10"/>
  <polygon points="48,36 48,92 96,64" fill="url(#grad1)"/>
</svg>
  `)}`;

    const ICON_SVG_PAUSE = `data:image/svg+xml;utf8,${encodeURIComponent(`
<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="128" height="128" viewBox="0 0 128 128">
  <defs>
    <linearGradient id="grad1" x1="0%" y1="0%" x2="100%" y2="100%">
      <stop offset="0%" style="stop-color:#7B61FF;stop-opacity:1"/>
      <stop offset="100%" style="stop-color:#FF6B6B;stop-opacity:1"/>
    </linearGradient>
  </defs>
  
  <circle cx="64" cy="64" r="59" fill="none" stroke="url(#grad1)" stroke-width="10"/>
  <rect x="42" y="36" width="14" height="56" rx="3" ry="3" fill="url(#grad1)"/>
  <rect x="74" y="36" width="14" height="56" rx="3" ry="3" fill="url(#grad1)"/>
</svg>
  `)}`;

    const WRAPPER_CLASS = '__cii-wrapper';
    const ICON_CLASS = 'voxi-mic-btn';
    const PAD_CLASS = '__cii-with-padding';
    const PAD_TEXTAREA_CLASS = '__cii-textarea-with-padding';
    let mediaRecorder = null;
    let audioStream = null;

    const transcriptEl = document.getElementById('transcript');

    function logStatus(s) {
        console.log(s);
    }

    function appendText(txt) {
        partialText = txt;
        transcriptEl.value = partialText;
        transcriptEl.scrollTop = transcriptEl.scrollHeight;
    }

    function isHidden(el) {
        const style = window.getComputedStyle(el);
        return (
            style.display === 'none' ||
            style.visibility === 'hidden' ||
            style.opacity === '0' ||
            el.offsetParent === null ||
            el.offsetWidth < 100
        );
    }

    function simulateTypingInstant(element, value) {
        const tag = element.tagName;
        const type = element.type;

        // Для input и textarea берём соответствующий прототип
        const proto = tag === 'TEXTAREA'
            ? HTMLTextAreaElement.prototype
            : HTMLInputElement.prototype;

        const valueSetter = Object.getOwnPropertyDescriptor(proto, 'value').set;
        const currentValue = element.value;

        // Не трогаем, если значение и так такое же
        if (currentValue === value) return;

        // Ставим фокус — многие сайты на этом завязаны
        element.focus();

        // Меняем value нативным setter'ом
        valueSetter.call(element, value);

        // Событие input — базовое, его слушает и “обычный” JS, и React/Vue и т.п.
        element.dispatchEvent(new Event('input', {bubbles: true}));

        // Если нужно зафиксировать ввод (например, по потере фокуса)
        element.dispatchEvent(new Event('change', {bubbles: true}));
    }

    async function voxi_start(el) {
        try {

            if (!el.__ws) {
                el.__ws = new WebSocket('wss://ws.heyvoxi.ru/ws');
            }

            console.log(el.__ws);

            let ws = el.__ws;
            let input = el.__cii_target;

            ws.onopen = () => logStatus('WS connected');
            ws.onclose = () => logStatus('WS closed');
            ws.onerror = () => logStatus('WS error');

            ws.onmessage = (ev) => {
                let finalText = '';
                let liveText = '';

                if (input.tagName === 'INPUT') {
                    finalText = input.value;
                } else if (input.tagName === 'TEXTAREA') {
                    finalText = input.innerHTML;
                }

                const msg = JSON.parse(ev.data);
                if (msg.type === "delta") {
                    for (let c of msg.commit) {
                        console.log(c);
                        finalText += (c.text || "");
                    }

                    liveText = (msg.live || []).map(x => x.text || "").join("");

                    finalText = finalText.trim();

                    simulateTypingInstant(input, finalText);

                    if (msg.flush) {
                        el.__ws.close();
                        el.__ws = null;
                    }

                    console.log(liveText.trim());
                } else if (msg.event === 'pong') {
                    console.log('pong received');
                }
            }

            audioStream = await navigator.mediaDevices.getUserMedia({
                audio: {
                    channelCount: 1,
                    echoCancellation: true,
                    noiseSuppression: true,
                    autoGainControl: true,
                }
            });

            // MediaRecorder выдаёт webm/opus (идеально для нашей серверной части)
            mediaRecorder = new MediaRecorder(audioStream, {
                mimeType: 'audio/webm;codecs=opus',
                audioBitsPerSecond: 64000
            });

            mediaRecorder.addEventListener('dataavailable', async (e) => {
                if (e.data && e.data.size > 0 && ws && ws.readyState === WebSocket.OPEN) {
                    const buf = await e.data.arrayBuffer();
                    ws.send(buf); // бинарные чанки
                }
            });

            mediaRecorder.start(250); // 250мс чанки -> низкая задержка

            logStatus('Recording…');

            el.__action = 'end';
            let icon = el.getElementsByClassName("voxi-icon")[0];
            icon.src = ICON_SVG_PAUSE;

        } catch (err) {
            console.error(err);
            logStatus('Error: ' + (err && err.message ? err.message : err));
        }
    }

    function voxi_end(el) {
        let ws = el.__ws;
        if (!ws) {
            logStatus('ws not inited');
            return;
        }

        try {
            if (mediaRecorder && mediaRecorder.state !== 'inactive') {
                mediaRecorder.stop();
            }
            if (audioStream) {
                audioStream.getTracks().forEach(t => t.stop());
            }

            if (ws && ws.readyState === WebSocket.OPEN) {
                ws.send(JSON.stringify({event: 'flush'}));

                // ws.close();
            }

            el.__action = 'start';
            let icon = el.getElementsByClassName("voxi-icon")[0];
            icon.src = ICON_SVG;


        }catch (err) {
            console.error(err);
        } finally {
            logStatus('stopped');
        }
    }

    function createIconNode() {
        const el = document.createElement('button');
        el.type = 'button';
        el.setAttribute('aria-label', 'Input action');
        el.className = ICON_CLASS;
        el.innerHTML = `<img class="voxi-icon" src="${ICON_SVG}" alt="" draggable="false" style="width:100%;height:100%;display:block;">`;
        el.style.border = 'none';
        el.style.background = 'transparent';
        el.style.padding = '0';
        el.style.margin = '0';
        el.__ws = null;
        el.__action = 'start';

        el.addEventListener('click', async (ev) => {
            ev.stopPropagation();
            ev.preventDefault();

            if (el.__action === 'start') {
                await voxi_start(el);
            } else if (el.__action === 'end') {
                await voxi_end(el);
            }

        });

        return el;
    }

    function wrapInput(input) {
        if (!input || input.__cii_wrapped) return;
        if (input.type === 'file') return;
        if (isHidden(input)) return;

        const wrapper = document.createElement('span');
        wrapper.className = WRAPPER_CLASS;
        wrapper.style.display = getComputedStyle(input).display === 'block' ? 'block' : 'inline-block';

        input.parentNode.insertBefore(wrapper, input);
        wrapper.appendChild(input);

        if (input.tagName.toLowerCase() === 'textarea') {
            input.classList.add(PAD_TEXTAREA_CLASS);
        } else {
            input.classList.add(PAD_CLASS);
        }

        const icon = createIconNode();
        icon.__cii_target = input;
        wrapper.appendChild(icon);

        input.__cii_wrapped = true;
    }

    function unwrapInput(input) {
        if (!input || !input.__cii_wrapped) return;
        const wrapper = input.parentNode;
        if (!wrapper || !wrapper.classList.contains(WRAPPER_CLASS)) return;

        wrapper.parentNode.insertBefore(input, wrapper);
        wrapper.remove();
        input.__cii_wrapped = false;
        input.classList.remove(PAD_CLASS, PAD_TEXTAREA_CLASS);
    }

    function scanAndWrap(root = document) {
        const selector = 'input:not([type=hidden]):not([data-cii-skip]):not([type="checkbox"]):not([type="radio"]):not([type="file"]):not([type="submit"]):not([type="password"]), textarea:not([data-cii-skip]), [role="textbox"], [contenteditable="true"]';
        const nodes = Array.from(root.querySelectorAll(selector));
        nodes.forEach(node => {
            if (!isHidden(node)) wrapInput(node);
        });
    }

    const observer = new MutationObserver((mutations) => {
        for (const m of mutations) {
            if (m.type === 'childList') {
                m.addedNodes.forEach(node => {
                    if (!(node instanceof HTMLElement)) return;
                    if (node.matches && (node.matches('input') || node.matches('textarea'))) {
                        if (!isHidden(node)) wrapInput(node);
                    } else {
                        scanAndWrap(node);
                    }
                });

                m.removedNodes.forEach(node => {
                    if (!(node instanceof HTMLElement)) return;
                    if (node.querySelectorAll) {
                        const wrapped = node.querySelectorAll('input.__cii-wrapped, textarea.__cii-wrapped');
                        wrapped.forEach(unwrapInput);
                    }
                });
            }
            if (m.type === 'attributes' && m.target) {
                const t = m.target;
                if (t.matches && (t.matches('input') || t.matches('textarea'))) {
                    if (!t.__cii_wrapped && !isHidden(t)) {
                        wrapInput(t);
                    }
                }
            }
        }
    });

    observer.observe(document.documentElement || document.body, {
        childList: true,
        subtree: true,
        attributes: true,
        attributeFilter: ['type', 'style', 'class']
    });

    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', () => scanAndWrap(document));
    } else {
        scanAndWrap(document);
    }

    window.__cii = {
        wrapAll: () => scanAndWrap(document),
        unwrapAll: () => {
            document.querySelectorAll('input,textarea').forEach(unwrapInput);
        }
    };

})();